#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "codeeditor.h"
//#include "consoleeditor.h"//should be ...
#include "parser.h"
#include <QtWidgets>
#include <QMessageBox>
#include <QListWidget>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    // menu and toolbar actions
    QObject::connect(this->ui->actionNew, SIGNAL(triggered()), this, SLOT(onNewDoc()));
    QObject::connect(this->ui->actionOpen, SIGNAL(triggered()), this, SLOT(onOpen()));
    QObject::connect(this->ui->actionSave, SIGNAL(triggered()), this, SLOT(onSave()));
    QObject::connect(this->ui->actionSave_All, SIGNAL(triggered()), this, SLOT(onSaveAll()));
    QObject::connect(this->ui->actionSave_As, SIGNAL(triggered()), this, SLOT(onSaveAs()));
    QObject::connect(this->ui->actionClose_Tab, SIGNAL(triggered()), this, SLOT(onCloseTab()));
    QObject::connect(this->ui->actionClose_All, SIGNAL(triggered()), this, SLOT(closeAllTabs()));
    QObject::connect(this->ui->actionExit, SIGNAL(triggered()), this, SLOT(close()));
    QObject::connect(this->ui->actionCopy, SIGNAL(triggered()), this, SLOT(onCopyText()));
    QObject::connect(this->ui->actionCut, SIGNAL(triggered()), this, SLOT(onCutText()));
    QObject::connect(this->ui->actionPaste, SIGNAL(triggered()), this, SLOT(onPasteText()));
    QObject::connect(this->ui->actionUndo, SIGNAL(triggered()), this, SLOT(onUndoText()));
    QObject::connect(this->ui->actionRedo, SIGNAL(triggered()), this, SLOT(onRedoText()));
    QObject::connect(this->ui->actionSelect_All, SIGNAL(triggered()), this, SLOT(onSelectAllText()));
    QObject::connect(this->ui->actionFind, SIGNAL(triggered()), this, SLOT(onFindText()));
    QObject::connect(this->ui->actionBuild, SIGNAL(triggered()), this, SLOT(onBuild()));
    QObject::connect(this->ui->actionRun, SIGNAL(triggered()), this, SLOT(onRun()));
    QObject::connect(this->ui->actionAbout, SIGNAL(triggered()), this, SLOT(onAboutEditor()));

    QObject::connect(this->ui->tabWidget, SIGNAL(tabCloseRequested(int)), this, SLOT(onCloseTab(int)));
    QObject::connect(this->ui->tabWidget, SIGNAL(currentChanged(int)), this, SLOT(onTabChanged()));
    QObject::connect(this->ui->tabWidget_2, SIGNAL(currentChanged(int)), this, SLOT(onDockTabChanged(int)));

    ui->tabWidget->removeTab(ui->tabWidget->indexOf(ui->tab));
    ui->tabWidget->removeTab(ui->tabWidget->indexOf(ui->tab_2));
    ui->tabWidget->setTabsClosable(true);

    ui->dockWidget->setWindowTitle("");
    ui->tabWidget_2->setTabText(0, "Find");
    ui->tabWidget_2->setTabText(1, "Build");
    ui->tabWidget_2->setTabText(2, "Run");
    //addConsoleTab();

    QObject::connect(this->ui->pushButtonFind, SIGNAL(clicked()), this, SLOT(findText()));
    ui->dockWidget->setMinimumHeight(150);
    ui->dockWidget->hide();

    // management of build-process
    procBuild = new QProcess();
    connect(procBuild, SIGNAL(readyReadStandardOutput ()), this, SLOT(onProcBuildReadOutputReady()));
    connect(procBuild, SIGNAL(readyReadStandardError()), this, SLOT(onProcBuildReadErrorReady()));
    connect(procBuild, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(onProcBuildFinished()));

    // management of run-process
    procRun = new QProcess();
    connect(procRun, SIGNAL(readyReadStandardOutput ()), this, SLOT(onProcRunReadOutputReady()));
    connect(procRun, SIGNAL(readyReadStandardError()), this, SLOT(onProcRunReadErrorReady()));
    connect(procRun, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(onProcRunFinished()));

    //
    this->installEventFilter(this);
    ui->plainTextEditBuild->viewport()->installEventFilter(this);
    buildIndex = -1;

    resize(QDesktopWidget().availableGeometry(this).size() * 0.7);
    lastOpenPath = QDir::homePath();
}

MainWindow::~MainWindow()
{
    delete ui;
}

bool MainWindow::eventFilter(QObject *obj, QEvent *event)
{
    // when double click the build result
    if ((obj == ui->plainTextEditBuild || obj == ui->plainTextEditBuild->viewport()) &&
        event->type() == QEvent::MouseButtonDblClick)
    {
        QMouseEvent *mouseEvent = static_cast<QMouseEvent*>(event);
        QPoint point(mouseEvent->x(), mouseEvent->y());
        QTextCursor cur = ui->plainTextEditBuild->cursorForPosition(point);
        cur.movePosition(QTextCursor::StartOfBlock,QTextCursor::MoveAnchor);
        cur.movePosition(QTextCursor::EndOfBlock, QTextCursor::KeepAnchor);
        QString s = cur.selection().toPlainText();
        QString s2 = "at line ";
        QString s3 = "between columns ";
        QString s4 = "and ";
        int lineNumber = 0;
        int columnNumber1 = 0;
        int columnNumber2 = 0;

        int index = s.indexOf(s2);
        if(index == -1)
        {
            return QWidget::eventFilter(obj, event);
        }
        s = s.mid(index + s2.length());
        index = s.indexOf(" ");
        if(index == -1)
        {
            return QWidget::eventFilter(obj, event);
        }
        lineNumber = s.mid(0, index).toInt();

        index = s.indexOf(s3);
        if(index == -1)
        {
            return QWidget::eventFilter(obj, event);
        }
        s = s.mid(index + s3.length());
        index = s.indexOf(" ");
        if(index == -1)
        {
            return QWidget::eventFilter(obj, event);
        }
        columnNumber1 = s.mid(0, index).toInt();

        index = s.indexOf(s4);
        if(index == -1)
        {
            return QWidget::eventFilter(obj, event);
        }
        s = s.mid(index + s4.length());
        index = -1;
        for(int i = 0; i < s.length(); i++)
        {
            if(s.at(i).toLatin1() < '0' || s.at(i).toLatin1() > '9')
            {
                index = i;
                break;
            }
        }

        if(index == -1)
        {
            columnNumber2 = s.toInt();
        }
        else
        {
            columnNumber2 = s.mid(0, index).toInt();
        }

        if(buildIndex >= 0)
        {
            ui->tabWidget->setCurrentIndex(buildIndex);
        }
        CodeEditor *codeEditor = getCurrentCodeEditor();
        codeEditor->selectSection(lineNumber, columnNumber1, columnNumber2);
    }
    return QWidget::eventFilter(obj, event);
}

/*
Get current plaintexteditor.
*/
CodeEditor *MainWindow::getCurrentCodeEditor()
{
    QWidget *tab = ui->tabWidget->currentWidget();
    QList<CodeEditor *> list = tab->findChildren<CodeEditor *>();
    CodeEditor *codeEditor = (CodeEditor *)list.at(0);
    return codeEditor;
}

// get codeeditor of specified index
CodeEditor *MainWindow::getCodeEditor(int index)
{
    QWidget *tab = ui->tabWidget->widget(index);
    QList<CodeEditor *> list = tab->findChildren<CodeEditor *>();
    CodeEditor *codeEditor = (CodeEditor *)list.at(0);
    return codeEditor;
}

// add new tab
void MainWindow::addNewTabWidget()
{
    QWidget *tab = new QWidget();
    tab->setObjectName(QStringLiteral("tab"));
    QVBoxLayout *verticalLayout = new QVBoxLayout(tab);
    verticalLayout->setSpacing(6);
    verticalLayout->setContentsMargins(11, 11, 11, 11);
    verticalLayout->setObjectName(QStringLiteral("verticalLayout"));
    CodeEditor *plainTextEdit = new CodeEditor(tab);// should be ConsoleEditor
    plainTextEdit->setObjectName(QStringLiteral("plainTextEdit"));

    verticalLayout->addWidget(plainTextEdit);

    ui->tabWidget->addTab(tab, QString());
    ui->tabWidget->setTabText(ui->tabWidget->indexOf(tab), QApplication::translate("Bee Editor", "New Document", 0));

    ui->tabWidget->setCurrentIndex(ui->tabWidget->count() - 1);
    connect(plainTextEdit->document(), SIGNAL(contentsChanged()), this, SLOT(documentWasModified()));//dragon

    fileNameList.append("");

    plainTextEdit->setFocus();
    onTabChanged();
}

void MainWindow::addConsoleTab()
{
    QWidget *tab = new QWidget();
    tab->setObjectName(QStringLiteral("tab"));
    QVBoxLayout *verticalLayout = new QVBoxLayout(tab);
    verticalLayout->setSpacing(6);
    verticalLayout->setContentsMargins(11, 11, 11, 11);
    verticalLayout->setObjectName(QStringLiteral("verticalLayout"));
    CodeEditor *plainTextEdit = new CodeEditor(tab);
    plainTextEdit->setObjectName(QStringLiteral("plainTextEdit"));

    verticalLayout->addWidget(plainTextEdit);

    ui->tabWidget_2->addTab(tab, QString());
    ui->tabWidget_2->setTabText(ui->tabWidget_2->indexOf(tab), QApplication::translate("Bee Editor", "Console for build", 0));
}

//mark tab as modified when document is modified.
void MainWindow::documentWasModified(int index)
{
    QWidget *tab;
    if(index == -1)
        tab = ui->tabWidget->currentWidget();
    else
        tab = ui->tabWidget->widget(index);

    QString str = ui->tabWidget->tabText(ui->tabWidget->indexOf(tab));
    int len = str.length();
    if(str.endsWith(" *"))
    {
        str = str.mid(0, len-2);
    }

    CodeEditor *codeEditor = this->getCurrentCodeEditor();
    if(codeEditor->document()->isModified())
    {
        str += " *";
    }
    ui->tabWidget->setTabText(ui->tabWidget->indexOf(tab), str);
    codeEditor->setFocus();
}

void MainWindow::onNewDoc()
{
    addNewTabWidget();
}

void MainWindow::onOpen()
{
    QString selfilter = tr("Bee source (*.b)");
    QString fileName = QFileDialog::getOpenFileName( this, "Select file", lastOpenPath,
            tr("All files (*.*);;Bee source (*.b)" ), &selfilter );

    if (!fileName.isEmpty())
    {
        if(fileNameList.contains(fileName))
        {
            int i = fileNameList.indexOf(fileName);
            ui->tabWidget->setCurrentIndex(i);
            return;
        }
        loadFile(fileName);

        QFileInfo fi(fileName);
        lastOpenPath = fi.baseName();
    }
}

bool MainWindow::onSave()
{
    if(ui->tabWidget->count() == 0)
    {
        QMessageBox::warning(this, "Warning", "No document to save");
        return false;
    }
    QString fileName = fileNameList[ui->tabWidget->currentIndex()];
    if (fileName.isEmpty()) {
        return onSaveAs();
    } else {
        return saveFile(fileName);
    }
}

bool MainWindow::onSaveAs()
{
    if(ui->tabWidget->count() == 0)
    {
        QMessageBox::warning(this, "Warning", "No document to save");
        return false;
    }

    QFileDialog dialog(this);
    dialog.setWindowModality(Qt::WindowModal);
    dialog.setAcceptMode(QFileDialog::AcceptSave);
    QStringList files;
    if (dialog.exec())
        files = dialog.selectedFiles();
    else
        return false;

    bool b = saveFile(files.at(0));
    if(b)
    {
        QString fileName = files.at(0);
        int index = ui->tabWidget->currentIndex();
        fileNameList[index] = fileName;

        // set tab name
        QWidget *tab = ui->tabWidget->currentWidget();
        index = fileName.lastIndexOf("/");
        QString str = fileName.mid(index+1);
        ui->tabWidget->setTabText(ui->tabWidget->indexOf(tab), str);
    }
    return b;
}

void MainWindow::onSaveAll()
{
    if(ui->tabWidget->count() == 0)
    {
        QMessageBox::warning(this, "Warning", "No document to save");
        return;
    }

    int i = 0;
    foreach (QString fileName, fileNameList) {
        QMessageBox::about(NULL, "", fileName);
        if (!fileName.isEmpty()) {
            saveFile(fileName, i);
        }
        i++;
    }
}
void MainWindow::onCloseTab(int index)
{
    if(ui->tabWidget->count() == 0)
    {
        QMessageBox::warning(this, "Warning", "No document to close");
        return;
    }
    if(index == -1)
    {
        index = ui->tabWidget->currentIndex();
    }

    if (maybeSave(index)) {
        ui->tabWidget->removeTab(index);
        fileNameList.removeAt(index);

        if(index == buildIndex)
        {
            buildIndex = -1;
            ui->plainTextEditBuild->setPlainText("");
            ui->dockWidget->setWindowTitle("");
        }
        //event->accept();
    } else {
        //event->ignore();
    }
}

void MainWindow::closeAllTabs()
{
    CodeEditor * codeEditor = getCurrentCodeEditor();
    codeEditor->find("aa");
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    if (exitProgram()) {
        event->accept();
    } else {
        event->ignore();
    }
}

void MainWindow::onTabChanged()
{
    QString s = "    Find in the document ";
    int index = ui->tabWidget->currentIndex();
    if(index >= 0 && index < fileNameList.count())
        s += fileNameList[index];

    index = ui->tabWidget_2->currentIndex();
    if(index == 0)
    {
        ui->dockWidget->setWindowTitle(s);
    }
}

void MainWindow::onDockTabChanged(int index)
{
    QString s = "";
    if(index == 0)
    {
        s = "    Find in the document ";
        int index = ui->tabWidget->currentIndex();
        if(index < fileNameList.count())
            s += fileNameList[index];
    }
    else if(index == 1)
    {
        if(buildIndex != -1)
        {
            s = "    Build result of program ";
            s += fileNameList[buildIndex];
        }
    }
    else if(index == 2)
    {
        if(buildIndex != -1)
        {
            s = "    Run result of program ";
            s += fileNameList[buildIndex];
        }
    }

    ui->dockWidget->setWindowTitle(s);
}

void MainWindow::onBuild()
{    
    if( !QFile::exists(QDir::homePath() + "/.beeprogram.org/binaries/bee"))
    {
        QMessageBox::warning(this, "Warning", "Bee is not installed");
        return;
    }

    if(ui->tabWidget->count() == 0)
    {
        QMessageBox::warning(this, "Warning", "No program to build");
        return;
    }
    QString fileName = fileNameList[ui->tabWidget->currentIndex()];
    bool b = false;
    if (fileName.isEmpty()) {
        b = onSaveAs();
    } else {
        b = saveFile(fileName);
    }
    fileName = fileNameList[ui->tabWidget->currentIndex()];

    if(!b)
    {
        QMessageBox::warning(this, "Warning", "Will not build without saving.");
        return;
    }

    executingRun = false;
    startBuild(fileName);
}

void MainWindow::startBuild(QString fileName)
{
    ui->dockWidget->show();
    ui->tabWidget_2->setCurrentIndex(1);
    ui->plainTextEditBuild->setPlainText("");
    ui->plainTextEditRun->setPlainText("");
    buildIndex = ui->tabWidget->currentIndex();
    onDockTabChanged(1);

    QString outName;
    int index = fileName.lastIndexOf(".");
    if(index < 0)
    {
        outName = fileName;
    }
    else
    {
        outName = fileName.mid(0, index);
    }

    QStringList arguments;

    arguments << "-o";
    arguments << outName;
    arguments << "-I";
    arguments << QDir::homePath() + "/.beeprogram.org/standard library";
    arguments << "preludedefinitions.b";
    arguments << "lists.b";
    arguments << "strings.b";
    arguments << "printf.b";
    arguments << "arrays.b";
    arguments << "int64.b";
    arguments << fileName;

    buildFinished = false;
    procBuild->start(QDir::homePath() + "/.beeprogram.org/binaries/bee", arguments);

}

void MainWindow::startRun(QString fileName)
{
    ui->dockWidget->show();
    ui->tabWidget_2->setCurrentIndex(2);
    //ui->plainTextEditRun->setPlainText("");
    buildIndex = ui->tabWidget->currentIndex();
    onDockTabChanged(2);

    QString outName;
    int index = fileName.lastIndexOf(".");
    if(index < 0)
    {
        outName = fileName;
    }
    else
    {
        outName = fileName.mid(0, index);
    }

    QStringList arguments;
    arguments << outName;

    procRun->start(QDir::homePath() + "/.beeprogram.org/binaries/beerun", arguments);

}

void MainWindow::onRun()
{
    if( !QFile::exists(QDir::homePath() + "/.beeprogram.org/binaries/bee"))
    {
        QMessageBox::warning(this, "Warning", "Bee is not installed");
        return;
    }

    if(ui->tabWidget->count() == 0)
    {
        QMessageBox::warning(this, "Warning", "No program to Run");
        return;
    }

    QString fileName = fileNameList[ui->tabWidget->currentIndex()];
    bool b = false;
    if (fileName.isEmpty()) {
        b = onSaveAs();
    } else {
        b = saveFile(fileName);
    }
    fileName = fileNameList[ui->tabWidget->currentIndex()];

    if(!b)
    {
        QMessageBox::warning(this, "Warning", "Will not run without saving.");
        return;
    }

    executingRun = true;
    executingFileName = fileName;
    startBuild(fileName);
}

void MainWindow::appendTextToBuild(QString s)
{
    QString plainText = ui->plainTextEditBuild->document()->toPlainText();
    if(plainText.isEmpty())
        plainText = s;
    else
        plainText += "\n" + s;

    ui->plainTextEditBuild->setPlainText(plainText);
}

void MainWindow::appendTextToRun(QString s)
{
    QString plainText = ui->plainTextEditRun->document()->toPlainText();
    if(plainText.isEmpty())
        plainText = s;
    else
        plainText += "\n" + s;

    ui->plainTextEditRun->setPlainText(plainText);
}

/////////////////////////////////////////////

void MainWindow::onProcBuildReadOutputReady()
{
    QString s = procBuild->readAllStandardOutput();
    appendTextToBuild(s);
}

void MainWindow::onProcBuildReadErrorReady()
{
    QString s = procBuild->readAllStandardError();
    appendTextToBuild(s);
}

void MainWindow::onProcBuildFinished()//int exitCode, QProcess::ExitStatus exitStatus
{
    statusBar()->showMessage(tr("Build finished"), 5000);
    //appendTextToBuild("Build finished");
    buildFinished = true;
    if(executingRun)
    {
        if(ui->plainTextEditBuild->document()->toPlainText().indexOf("error") == -1)
            startRun(executingFileName);
    }
}

////////////////////////////////////////////

void MainWindow::onProcRunReadOutputReady()
{
    QString s = procRun->readAllStandardOutput();
    appendTextToRun(s);
}

void MainWindow::onProcRunReadErrorReady()
{
    QString s = procRun->readAllStandardError();
    appendTextToRun(s);
}

void MainWindow::onProcRunFinished()//int exitCode, QProcess::ExitStatus exitStatus
{
    statusBar()->showMessage(tr("Run finished"), 5000);
    //appendTextToBuild("Run finished");
}

/////////////////////////////////////////

bool MainWindow::exitProgram()
{
    bool b = false;
    for(int i = 0; i< ui->tabWidget->count(); i++)
    {
        CodeEditor *codeEditor = getCodeEditor(i);
        if(codeEditor->document()->isModified())
        {
            b = true;
            break;
        }
    }
    if(b)
    {
        QMessageBox::StandardButton ret;
        ret = QMessageBox::warning(this, tr("Warning"), tr("Some documents are modified.\n Do you want to quit anyway?"),
                     QMessageBox::Ok | QMessageBox::Cancel);
        if (ret == QMessageBox::Ok)
        {
            return true;
        }
    }
    else
    {
        return true;
    }
    return false;
}

void MainWindow::onCopyText()
{
    if(ui->tabWidget->count() == 0)
    {
        return;
    }
    CodeEditor *codeEditor = this->getCurrentCodeEditor();
    codeEditor->copy();
}

void MainWindow::onCutText()
{
    if(ui->tabWidget->count() == 0)
    {
        return;
    }
    CodeEditor *codeEditor = this->getCurrentCodeEditor();
    codeEditor->cut();
}

void MainWindow::onPasteText()
{
    if(ui->tabWidget->count() == 0)
    {
        return;
    }
    CodeEditor *codeEditor = this->getCurrentCodeEditor();
    codeEditor->paste();
}

void MainWindow::onUndoText()
{
    if(ui->tabWidget->count() == 0)
    {
        return;
    }
    CodeEditor *codeEditor = this->getCurrentCodeEditor();
    codeEditor->undo();
}

void MainWindow::onRedoText()
{
    if(ui->tabWidget->count() == 0)
    {
        return;
    }
    CodeEditor *codeEditor = this->getCurrentCodeEditor();
    codeEditor->redo();
}

void MainWindow::onSelectAllText()
{
    if(ui->tabWidget->count() == 0)
    {
        return;
    }
    CodeEditor *codeEditor = this->getCurrentCodeEditor();
    codeEditor->selectAll();
}

void MainWindow::onFindText()
{
    if(ui->tabWidget->count() == 0)
    {
        QMessageBox::warning(this, "", "No document to find");
        return;
    }

    ui->dockWidget->show();
    ui->tabWidget_2->setCurrentIndex(0);
    ui->lineEditFind->setFocus();
    onDockTabChanged(0);
}

void MainWindow::findText()
{
    if(ui->tabWidget->count() == 0)
    {
        QMessageBox::warning(this, "Warning", "No document to find");
        return;
    }
    QString findStr = ui->lineEditFind->text();
    if(findStr.isEmpty())
    {
        QMessageBox::warning(this, "Warning", "No string to find");
        return;
    }

    CodeEditor *codeEditor = this->getCurrentCodeEditor();
    codeEditor->setFocus();
    bool find = codeEditor->find(findStr);
    if(!find)
    {
        QMessageBox::StandardButton ret;
        ret = QMessageBox::warning(this, tr("Application"),
                     tr("You have reached the end of the document.\nDo you want to find from the start?"),
                     QMessageBox::Ok | QMessageBox::Cancel);
        if (ret == QMessageBox::Ok)
        {
            codeEditor->moveCursor(QTextCursor::Start);
            find = codeEditor->find(findStr);
            if(!find)
                QMessageBox::about(this, "Information", "No occurence of the string");
        }
    }
}

void MainWindow::onAboutEditor()
{
    QMessageBox::about(this, "About Editor", "About Bee Editor\nBee Editor is an open source editor for Bee programming.\nFor more information, visit http://beeprogam.org");
}
/*
    while True:
        # self.editor is the QPlainTextEdit
        r=self.editor.find(old,flags)
        if r:
            qc=self.editor.textCursor()
            if qc.hasSelection():
                qc.insertText(new)
        else:
            break
*/


bool MainWindow::maybeSave(int index)
{
    CodeEditor *codeEditor = this->getCodeEditor(index);
    if (codeEditor->document()->isModified()) {
        QMessageBox::StandardButton ret;
        ret = QMessageBox::warning(this, tr("Application"),
                     tr("The document has been modified.\nDo you want to save your changes?"),
                     QMessageBox::Save | QMessageBox::Discard | QMessageBox::Cancel);
        if (ret == QMessageBox::Save)
        {
            QString fileName = fileNameList.at(index);
            if(fileName.isEmpty())
            {
                QFileDialog dialog(this);
                dialog.setWindowModality(Qt::WindowModal);
                dialog.setAcceptMode(QFileDialog::AcceptSave);
                QStringList files;
                if (dialog.exec())
                    files = dialog.selectedFiles();
                else
                    return false;

                return saveFile(files.at(0), index);
            }
            else
            {
                return saveFile(fileName, index);
            }
            return onSave();
        }
        else if (ret == QMessageBox::Cancel)
            return false;
    }
    return true;
}

bool MainWindow::saveFile(const QString &fileName, int index)
{
    QFile file(fileName);
    if (!file.open(QFile::WriteOnly | QFile::Text)) {
        QMessageBox::warning(this, tr("Application"),
                             tr("Cannot write file %1:\n%2.")
                             .arg(fileName)
                             .arg(file.errorString()));
        return false;
    }

    CodeEditor *codeEditor;
    if(index == -1)
        codeEditor = this->getCurrentCodeEditor();
    else
        codeEditor = getCodeEditor(index);

    QTextStream out(&file);
#ifndef QT_NO_CURSOR
    QApplication::setOverrideCursor(Qt::WaitCursor);
#endif
    out << codeEditor->toPlainText();
#ifndef QT_NO_CURSOR
    QApplication::restoreOverrideCursor();
#endif

    setCurrentFile(fileName);
    statusBar()->showMessage(tr("File saved"), 2000);

    // mark current document as unmodified.
    codeEditor->document()->setModified(false);
    documentWasModified(index);

    return true;
}

void MainWindow::setCurrentFile(const QString &fileName)
{
    CodeEditor *codeEditor = this->getCurrentCodeEditor();

    curFile = fileName;
    codeEditor->document()->setModified(false);
    setWindowModified(false);

    QString shownName = curFile;
    if (curFile.isEmpty())
        shownName = "untitled.txt";
    setWindowFilePath(shownName);
}

void MainWindow::loadInitialFile(const QString &initFileName)
{
    loadFile(initFileName);
}

void MainWindow::loadFile(const QString &fileName)
{
    QFile file(fileName);
    if (!file.open(QFile::ReadOnly | QFile::Text)) {
        QMessageBox::warning(this, tr("Application"),
                             tr("Cannot read file %1:\n%2.")
                             .arg(fileName)
                             .arg(file.errorString()));
        return;
    }

    QTextStream in(&file);
#ifndef QT_NO_CURSOR
    QApplication::setOverrideCursor(Qt::WaitCursor);
#endif

    // add new tab and load the content of the file
    addNewTabWidget();
    CodeEditor *codeEditor = this->getCurrentCodeEditor();
    codeEditor->setPlainText(in.readAll());

    // set tab name
    QWidget *tab = ui->tabWidget->currentWidget();
    int index = fileName.lastIndexOf("/");
    QString str = fileName.mid(index+1);
    ui->tabWidget->setTabText(ui->tabWidget->indexOf(tab), str);

    // save opened file path
    fileNameList.last() = fileName;

#ifndef QT_NO_CURSOR
    QApplication::restoreOverrideCursor();
#endif

    codeEditor->setFocus();
    setCurrentFile(fileName);
    statusBar()->showMessage(tr("File loaded"), 2000);

    onTabChanged();
}

