#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QProcess>

namespace Ui {
class MainWindow;
}

class CodeEditor;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void closeEvent(QCloseEvent *event) Q_DECL_OVERRIDE;
    bool eventFilter(QObject *obj, QEvent *event);

public slots:
    void addNewTabWidget();
    void onNewDoc();
    void onOpen();
    bool onSave();
    bool onSaveAs();
    void onSaveAll();
    void onCloseTab(int index = -1);
    void closeAllTabs();
    bool exitProgram();
    void onCopyText();
    void onCutText();
    void onPasteText();
    void onUndoText();
    void onRedoText();
    void onSelectAllText();
    void onFindText();
    void findText();
    void onAboutEditor();
    void onBuild();
    void onRun();
    void onProcBuildReadOutputReady();
    void onProcBuildReadErrorReady();
    void onProcBuildFinished();
    void onProcRunReadOutputReady();
    void onProcRunReadErrorReady();
    void onProcRunFinished();
    void onTabChanged();
    void onDockTabChanged(int index);

    void startBuild(QString fileName);
    void startRun(QString fileName);
    bool maybeSave(int index);
    bool saveFile(const QString &fileName, int index = -1);
    void documentWasModified(int index = -1);
    void loadInitialFile(const QString &fileName);

private:
    void appendTextToBuild(QString s);
    void appendTextToRun(QString s);
    CodeEditor *getCurrentCodeEditor();
    CodeEditor *getCodeEditor(int index);
    void setCurrentFile(const QString &fileName);
    void loadFile(const QString &fileName);
    void addConsoleTab();
    QString curFile;
    QString lastOpenPath;
private:
    Ui::MainWindow *ui;
    QStringList fileNameList;
    int buildIndex; // index of tab for which build is.

    QProcess *procBuild;
    QProcess *procRun;
    bool buildFinished;
    bool executingRun; // clicked "run"?
    QString executingFileName;
};

#endif // MAINWINDOW_H
