#include "parser.h"
#include "codeeditor.h"

Parser::Parser()
{
    keywords << "and";
    keywords << "else";
    keywords << "fun";
    keywords << "if";
    keywords << "in";
    keywords << "let";
    keywords << "not";
    keywords << "rec";
    keywords << "then";

    keywords << "match";
    keywords << "end";
    keywords << "with";
    keywords << "function";

    keywords << "case";

    keywords << "type";
    keywords << "of";
    keywords << "mutable";

    keywords << "module";
    keywords << "endmodule";

    keywords << "val";
    keywords << "external";

    keywords << "mod";
    keywords << "land";
    keywords << "lor";
    keywords << "lxor";
    keywords << "lsl";
    keywords << "lsr";
    keywords << "asr";

    keywords << "printf";
    keywords << "int";
    keywords << "string";
    keywords << "float";
    keywords << "boolean";
}

ContextElementList Parser::splitDivisibleContextElement( struct ContextElement parent)
{
    QList<struct ContextElement> list;
    if( !parent.divisible)
    {
        list.append(parent);
        return list;
    }
    QString str = parent.str;
    QChar currChar;
    char c;
    int startPos = 0, currPos = 0;
    int lineNumber = parent.lineNumber, currLineNumber = lineNumber;
    int columnNumber = parent.columnNumber, currColumnNumber = columnNumber;
    int len = str.length();

    for(int i = 0; i < len; i++)
    {
firstStep:
        currChar = str.at(i);
        c = currChar.toLatin1();
        currPos = i;

        switch (c){
        case '(':
        case ')':
        case '[':
        case ']':
        case '{':
        case '}':
        case '+':
        case '*':
        case '/':
        case ',':
        case ';':
        case '|':
        case '\'':
            {
secondStep:
                if(currPos > startPos)
                {
                    struct ContextElement element;
                    element.str = str.mid(startPos, currPos - startPos);
                    element.absPos = startPos + parent.absPos;
                    element.lineNumber = lineNumber;
                    element.columnNumber = columnNumber;
                    element.divisible = false;
                    element.errorNumber = ::ContextErrorUnchecked;
                    element.type = ::ContextTypeUnknown;
                    if( !element.str.simplified().isEmpty())
                        list.append(element);
                }

                struct ContextElement element;
                element.str = str.mid(currPos, 1);
                element.absPos = currPos + parent.absPos;
                element.lineNumber = currLineNumber;
                element.columnNumber = currColumnNumber;
                element.divisible = false;
                element.errorNumber = ::ContextErrorNone;
                element.type = ::ContextTypeUnknown;
                if( !element.str.simplified().isEmpty())
                    list.append(element);

                currColumnNumber++;

                lineNumber = currLineNumber; // next starting line number
                columnNumber = currColumnNumber; // next starting column number

                startPos = currPos + 1;
                continue;
            }
            break;
        case ' ':
        case '\t':
        case '\n':
            {
                if(currPos > startPos)
                {
                    struct ContextElement element;
                    element.str = str.mid(startPos, currPos - startPos);
                    element.absPos = startPos + parent.absPos;
                    element.lineNumber = lineNumber;
                    element.columnNumber = columnNumber;
                    element.divisible = false;
                    element.errorNumber = ::ContextErrorUnchecked;
                    element.type = ::ContextTypeUnknown;
                    if( !element.str.simplified().isEmpty())
                        list.append(element);
                }
                for(;i< len;i++)
                {
                    currChar = str.at(i);
                    c = currChar.toLatin1();

                    if(c != ' ' && c != '\t' && c != '\n')
                    {
                        startPos = i;

                        lineNumber = currLineNumber; // next starting line number
                        columnNumber = currColumnNumber; // next starting column number

                        goto firstStep;
                    }
                    if(c == '\n')
                    {
                        currLineNumber++;
                        currColumnNumber = 0;
                    }
                    else
                    {
                        currColumnNumber++;
                    }

                }
                if(i >= len)
                {
                    return list;
                }
            }
            break;
        case '=':
        case '<':
        case '>':
            if(i < len - 1 && str.at(i + 1).toLatin1() == '=')
            {
thirdStep:
                if(currPos > startPos)
                {
                    struct ContextElement element;
                    element.str = str.mid(startPos, currPos - startPos);
                    element.absPos = startPos + parent.absPos;
                    element.lineNumber = lineNumber;
                    element.columnNumber = columnNumber;
                    element.divisible = false;
                    element.errorNumber = ::ContextErrorUnchecked;
                    element.type = ::ContextTypeUnknown;
                    if( !element.str.simplified().isEmpty())
                        list.append(element);
                }

                struct ContextElement element;
                element.str = str.mid(currPos, 2);
                element.absPos = currPos + parent.absPos;
                element.lineNumber = currLineNumber;
                element.columnNumber = currColumnNumber;
                element.divisible = false;
                element.errorNumber = ::ContextErrorNone;
                element.type = ::ContextTypeUnknown;
                if( !element.str.simplified().isEmpty())
                    list.append(element);

                currColumnNumber += 2;

                lineNumber = currLineNumber; // next starting line number
                columnNumber = currColumnNumber; // next starting column number

                startPos = currPos + 2;
                i++;
                continue;
            }
            else
            {
                goto secondStep;
            }
            break;
        case ':':
            if(i < len - 1 && str.at(i + 1).toLatin1() == ':')
            {
                goto thirdStep;
            }
            else
            {
                goto secondStep;
            }
            break;
        case '-':
            if(i < len - 1 && str.at(i + 1).toLatin1() == '>')
            {
                goto thirdStep;
            }
            else
            {
                goto secondStep;
            }
            break;
        default:
            break;
        }

        if(currChar.toLatin1() == '\n')
        {
            currLineNumber++;
            currColumnNumber = 0;
        }
        else
        {
            currColumnNumber++;
        }
    }

    struct ContextElement element;
    element.str = str.mid(startPos, currPos - startPos + 1);
    element.absPos = startPos + parent.absPos;
    element.lineNumber = lineNumber;
    element.columnNumber = columnNumber;
    element.divisible = false;
    element.errorNumber = ::ContextErrorUnchecked;
    element.type = ::ContextTypeUnknown;
    if( !element.str.simplified().isEmpty())
        list.append(element);

    return list;
}

ContextElementList Parser::splitPlainText( QString plainText)
{
    QList<struct ContextElement> elementList;
    int startPos = 0, currPos = 0;
    int len = plainText.length();
    QString elementStr;
    QChar currChar, nextChar;
    int lineNumber = 0, currLineNumber = 0;
    int columnNumber = 0, currColumnNumber = 0;
    bool doubleQuoteStarted = false;
    //bool commentStarted = false;
    int commentNestCount = 0;
    for(int i = 0; i < len; i++)
    {
        currPos = i;
        currChar = plainText.at(i);
        if(currChar.toLatin1() == '"')
        {
            if(doubleQuoteStarted)
            {
                if( currPos - 1 >= 0 &&
                        plainText.at(currPos - 1).toLatin1() == '\\')
                {
                    ;//goto calcColumnNumber;
                }
                else // this is closing double-quote.
                {
                    if(currPos > startPos) // this should be true.
                    {
                        struct ContextElement element;
                        element.str = plainText.mid(startPos, currPos - startPos + 1);
                        element.absPos = startPos;
                        element.divisible = false;
                        element.lineNumber = lineNumber;
                        element.columnNumber = columnNumber;
                        element.errorNumber = ::ContextErrorNone;
                        element.type = ::ContextTypeValue;

                        elementList.append(element);

                        startPos = currPos + 1;

                        lineNumber = currLineNumber; // next starting line number
                        columnNumber = currColumnNumber + 1; // next starting column number
                    }
                    startPos = currPos + 1;
                    doubleQuoteStarted = false;
                    ;//goto calcColumnNumber;
                }
            }
            else // !doubleQuoteStarted, new double-quote
            {
                if(commentNestCount == 0) // free to start double-quote
                {
                    if( currPos - 2 >= 0 && currPos + 1 < len &&
                            plainText.at(currPos - 2).toLatin1() == '\'' &&
                            plainText.at(currPos - 1).toLatin1() == '\\' &&
                            plainText.at(currPos + 1).toLatin1() == '\'')
                    {
                        //'\"'
                        ;//goto calcColumnNumber;
                    }
                    else if( currPos - 1 >= 0 && currPos + 1 < len &&
                            plainText.at(currPos - 1).toLatin1() == '\'' &&
                             plainText.at(currPos + 1).toLatin1() == '\'')
                    {
                        //'"'
                        ;//goto calcColumnNumber;
                    }
                    else if( currPos - 1 >= 0 &&
                            plainText.at(currPos - 1).toLatin1() == '\\')
                    {
                        ;//goto calcColumnNumber;
                    }
                    else // this is starting double-quote.
                    {
                        if(currPos > startPos) // may not be true.
                        {
                            struct ContextElement element;
                            element.str = plainText.mid(startPos, currPos - startPos);
                            element.absPos = startPos;
                            element.divisible = true;
                            element.lineNumber = lineNumber;
                            element.columnNumber = columnNumber;
                            element.errorNumber = ::ContextErrorUnchecked;
                            element.type = ::ContextTypeUnknown;

                            elementList.append(element);

                            startPos = currPos;

                            lineNumber = currLineNumber;
                            columnNumber = currColumnNumber;
                        }
                        doubleQuoteStarted = true;
                        //goto calcColumnNumber;
                    }

                }
                else // this double-quote is in comment section.
                {
                    //goto calcColumnNumber;
                }
            }
        }
        else if(currChar.toLatin1() == '(')
        {
            if( i + 1 < len && plainText.at( i + 1).toLatin1() == '*')
            {
                if( !doubleQuoteStarted)// free to start comment
                {
                    if( commentNestCount == 0)// still no comment-nest
                    {
                        if(currPos > startPos) // may not be true.
                        {
                            struct ContextElement element;
                            element.str = plainText.mid(startPos, currPos - startPos);
                            element.absPos = startPos;
                            element.divisible = true;
                            element.lineNumber = lineNumber;
                            element.columnNumber = columnNumber;
                            element.errorNumber = ::ContextErrorUnchecked;
                            element.type = ::ContextTypeUnknown;

                            elementList.append(element);

                            startPos = currPos;

                            lineNumber = currLineNumber;
                            columnNumber = currColumnNumber;
                        }
                        startPos = currPos;
                    }
                    commentNestCount++;
                    ;//goto calcColumnNumber;
                }
                else
                {
                    //goto calcColumnNumber;
                }
            }
        }
        else if(currChar.toLatin1() == ')')
        {
            if( i - 1 >= 0 && plainText.at( i - 1).toLatin1() == '*')
            {
                if( commentNestCount == 1)// this is closing comment
                {
                    if(currPos > startPos) // should be true.
                    {
                        struct ContextElement element;
                        element.str = plainText.mid(startPos, currPos - startPos + 1);
                        element.absPos = startPos;
                        element.divisible = false;
                        element.lineNumber = lineNumber;
                        element.columnNumber = columnNumber;
                        element.errorNumber = ::ContextErrorNone;
                        element.type = ::ContextTypeComment;

                        elementList.append(element);

                        startPos = currPos + 1;

                        lineNumber = currLineNumber;
                        columnNumber = currColumnNumber + 1;
                    }
                    startPos = currPos + 1;
                    ;//goto calcColumnNumber;
                }
                else
                {
                    ;//goto calcColumnNumber;
                }
                if(commentNestCount > 0)
                    commentNestCount--;
            }

        }

        //calcColumnNumber:
        if(currChar.toLatin1() == '\n')
        {
            currLineNumber++;
            currColumnNumber = 0;
        }
        else
        {
            currColumnNumber++;
        }
    }

    if(commentNestCount > 0 || doubleQuoteStarted)
    {
        struct ContextElement element;
        element.str = plainText.mid(startPos, currPos - startPos + 1);
        element.absPos = startPos;
        element.divisible = false;

        if(doubleQuoteStarted)
            element.errorNumber = ::ContextErrorUnclosedDoubleQuote;
        else
            element.errorNumber = ::ContextErrorUnclosedComment;

        element.lineNumber = lineNumber;
        element.columnNumber = columnNumber;

        elementList.append(element);
    }
    else
    {
        if(startPos < len )
        {
            struct ContextElement element;
            element.str = plainText.mid(startPos, len - startPos);
            element.absPos = startPos;
            element.divisible = true;
            element.errorNumber = ::ContextErrorUnchecked;
            element.lineNumber = lineNumber;
            element.columnNumber = columnNumber;

            elementList.append(element);

        }
    }

    return elementList;
}

ContextElementList Parser::getContextElementList(QString plainText)
{
    QList<struct ContextElement> list;
    QList<struct ContextElement> list2 = this->splitPlainText(plainText);
    foreach (struct ContextElement element2, list2) {
        QList<struct ContextElement> list3 = this->splitDivisibleContextElement(element2);
        list += list3;
    }
    return list;
}

ContextElementList Parser::arrangeContextElementList(ContextElementList list)
{
    QList<struct ContextElement> dst, dst2;
    struct ContextElement element, element2, element3;
    int len = list.length();
    char c;
    int parenthesisOpenCount = 0, parenthesisCloseCount = 0;
    int bracketOpenCount = 0, bracketCloseCount = 0;
    int braceOpenCount = 0, braceCloseCount = 0;

    for(int i = 0; i < len;)
    {
        element = list[i];
        c= element.str.at(0).toLatin1();
        if( this->keywords.contains(element.str))
        {
            element.errorNumber = ::ContextErrorNone;
            element.type = ::ContextTypeKeyword;
        }
        else if(element.str == "(")
        {
            parenthesisOpenCount++;
            if(i+1 < len)
            {
                element2 = list[i+1];
                if( element2.str == ")") // unit----------()
                {
                    if( element2.absPos - element.absPos == 1)
                    {
                        parenthesisCloseCount++;
                        element.str = "()";
                        element.errorNumber = ::ContextErrorNone;
                        element.type = ::ContextTypeValue;

                        i++;
                    }
                }
            }
        }
        else if(element.str == "'")
        {
            element.errorNumber = ::ContextErrorUnclosedSingleQuote;
            element.type = ::ContextTypeValue;

            if(i+2 < len)
            {
                element3 = list[i+2];
                if( element3.str == "'") // closing single-quote
                {
                    element2 = list[i+1];

                    // default is bad character format
                    element.errorNumber = ::ContextErrorBadCharacterFormat;
                    element.type = ::ContextTypeValue;
                    element.str = "'" + element2.str + "'";// merge elements.
                    i += 2;

                    if(element2.str.length() == 1 )
                    {
                        if(element2.str == "\\")
                        {
                            if(i+1 < len)
                            {
                                if(list[i+1].str == "'") //'\''
                                {
                                    element.errorNumber = ::ContextErrorNone;
                                    element.str += "'";
                                    i++;
                                }
                            }
                        }
                        else if(element2.str != "'") //'c'
                        {
                            element.errorNumber = ::ContextErrorNone;
                        }
                    }
                    else
                    {
                        if(element2.str.startsWith("\\"))
                        {
                            QString str = element2.str.mid(1);
                            if( str == "a" || str == "b" || str == "f"||str == "n" ||
                                    str == "r"||str == "t"||str == "v" || str == "\\" ||
                                    /*str == "'" ||*/str == "\"" || str == "?")
                            {
                                element.errorNumber = ::ContextErrorNone; // escape character
                            }
                            else if(str.startsWith("x"))
                            {
                                if(str.length()== 3)
                                {
                                    element.errorNumber = ::ContextErrorNone;
                                    for(int j = 1; j<3; j++)
                                    {
                                        c = str.at(j).toLatin1();
                                        if(c < '0' || (c > '9' && c <'A') || (c > 'F' && c < 'a') || c > 'f')
                                        {
                                            //not '\xhh' format
                                            element.errorNumber = ::ContextErrorBadCharacterFormat;
                                            break;
                                        }
                                    }
                                }
                                else
                                {
                                    element.errorNumber = ::ContextErrorBadCharacterFormat;
                                }
                            }
                            else
                            {
                                bool ok;
                                int in = str.toInt(&ok);
                                if(ok && in >=0 && in < 256)
                                {
                                    element.errorNumber = ::ContextErrorNone; // '\nnn'
                                }
                                else
                                    element.errorNumber = ::ContextErrorBadCharacterFormat;
                            }
                        }
                        else
                        {
                            element.errorNumber = ::ContextErrorBadCharacterFormat;
                        }
                    }
                }
            }
        }
        else if(element.str == "[")
        {
            bracketOpenCount++;
        }
        else if(element.str == "{")
        {
            braceOpenCount++;
        }
        else if(element.str == ")")
        {
            parenthesisCloseCount++;
            if(parenthesisCloseCount > parenthesisOpenCount)
            {
                element.errorNumber = ::ContextErrorUnopenedParenthesis;
                element.type = ::ContextTypeValue;

                parenthesisOpenCount = 0, parenthesisCloseCount = 0;
            }
        }
        else if(element.str == "]")
        {
            bracketCloseCount++;
            if(bracketCloseCount > bracketOpenCount)
            {
                element.errorNumber = ::ContextErrorUnopenedBracket;
                element.type = ::ContextTypeValue;

                bracketOpenCount = 0, bracketCloseCount = 0;
            }
        }
        else if(element.str == "}")
        {
            braceCloseCount++;
            if(braceCloseCount > braceOpenCount)
            {
                element.errorNumber = ::ContextErrorUnopenedBrace;
                element.type = ::ContextTypeValue;

                braceOpenCount = 0, braceCloseCount = 0;
            }
        }
        else if(element.str.startsWith("0x"))// integer,for example 0xdeadbeef
        {
            element.errorNumber = ::ContextErrorNone;

            for(int j = 2; j<element.str.length(); j++)
            {
                c = element.str.at(j).toLatin1();
                if(c < '0' || (c > '9' && c <'A') || (c > 'F' && c < 'a') || c > 'f')
                {
                    element.errorNumber = ::ContextErrorBadNumberFormat;
                    break;
                }
            }
            element.type = ::ContextTypeValue;
        }
        else if(element.str.startsWith("0b"))// integer,for example 0b01100001001
        {
            element.errorNumber = ::ContextErrorNone;

            for(int j = 2; j<element.str.length(); j++)
            {
                c = element.str.at(j).toLatin1();
                if(c != '0' && c != '1')
                {
                    element.errorNumber = ::ContextErrorBadNumberFormat;
                    break;
                }
            }
            element.type = ::ContextTypeValue;
        }
        else if(c >= '0' && c <= '9')// number, for example 42.5, 2.345E10, 10
        {
            int dotCount = 0;
            int eCount = 0;

            for(int j = 1; j < element.str.length(); j++)
            {
                c = element.str.at(j).toLatin1();
                if(c < '0' || c > '9')
                {
                    if(c == '.')
                    {
                        if(eCount == 1)
                            goto badNumberValueType;

                        dotCount++;
                    }
                    else if(c == 'e' || c == 'E')
                    {
                        eCount++;
                    }
                    else
                    {
                        goto badNumberValueType;
                    }

                    if(dotCount > 1 || eCount > 1)
                    {
                        goto badNumberValueType;
                    }
                }
            }
            element.errorNumber = ::ContextErrorNone;
            element.type = ::ContextTypeValue;
            dst.append(element);
            i++;
            continue;

badNumberValueType:
            element.errorNumber = ::ContextErrorBadNumberFormat;
            element.type = ::ContextTypeValue;
            dst.append(element);
            i++;
            continue;
        }

        dst.append(element);
        i++;
    }

    parenthesisOpenCount = 0, parenthesisCloseCount = 0;
    bracketOpenCount = 0, bracketCloseCount = 0;
    braceOpenCount = 0, braceCloseCount = 0;
    len = dst.length();
    for(int i = len - 1; i >= 0; i--)
    {
        element = dst[i];
        c= element.str.at(0).toLatin1();

        if(element.str == "(")
        {
            parenthesisOpenCount++;
            if(parenthesisCloseCount < parenthesisOpenCount)
            {
                element.errorNumber = ::ContextErrorUnclosedParenthesis;
                element.type = ::ContextTypeValue;
                dst[i] = element;

                parenthesisOpenCount = 0, parenthesisCloseCount = 0;
            }
        }
        else if(element.str == "[")
        {
            bracketOpenCount++;
            if(bracketCloseCount < bracketOpenCount)
            {
                element.errorNumber = ::ContextErrorUnclosedBracket;
                element.type = ::ContextTypeValue;
                dst[i] = element;

                bracketOpenCount = 0, bracketCloseCount = 0;
            }
        }
        else if(element.str == "{")
        {
            braceOpenCount++;
            if(braceCloseCount < braceOpenCount)
            {
                element.errorNumber = ::ContextErrorUnclosedBrace;
                element.type = ::ContextTypeValue;
                dst[i] = element;

                braceOpenCount = 0, braceCloseCount = 0;
            }
        }
        else if(element.str == ")")
        {
            parenthesisCloseCount++;
        }
        else if(element.str == "]")
        {
            bracketCloseCount++;
        }
        else if(element.str == "}")
        {
            braceCloseCount++;
        }
    }
    return dst;
}
/*
QString Parser::indentString(ContextElementList list)
{

}*/
