#ifndef PARSER_H
#define PARSER_H

#include <QString>
#include <QList>
#include <QHash>
#include <QStringList>

struct ContextElement{
    bool divisible; // is this divisible?
    QString str; //
    int absPos; // absolute position in plaintext
    int lineNumber; // line number of this
    int columnNumber; // column number of
    int type; // is this keyword, value, or comment?
    int errorNumber; // 0 means no error
};

struct Construct{
    QString name; // name of identifier
    int paramCount; // count of parameter
    int tabCount; // default tab count of this definition
    bool delimitedByIn; // delimited by "in"?
};

typedef QList<struct ContextElement> ContextElementList;

typedef enum {
    ContextTypeUnknown = 0,
    ContextTypeKeyword,
    ContextTypeValue,
    ContextTypeComment,
} ContextType ;

typedef enum {
    ContextErrorUnchecked = 0,
    ContextErrorNone,
    ContextErrorUnclosedDoubleQuote,//"
    ContextErrorUnclosedSingleQuote,//'
    ContextErrorUnopenedParenthesis,//(
    ContextErrorUnclosedParenthesis,//(
    ContextErrorUnopenedBracket, //[
    ContextErrorUnclosedBracket,//[
    ContextErrorUnopenedBrace,//{
    ContextErrorUnclosedBrace,//{
    ContextErrorUnclosedComment, //(*
    ContextErrorBadNumberFormat,
    ContextErrorBadCharacterFormat,
} ContextError ;

class Parser
{
public:
    Parser();

public:
    ContextElementList splitPlainText( QString plainText);// split "" sections, comment sections,
    ContextElementList splitDivisibleContextElement( struct ContextElement parent); //split again
    ContextElementList getContextElementList(QString plainText);
    ContextElementList arrangeContextElementList(ContextElementList list);
    QHash<int, QString> errorMsg;
    
    QStringList keywords;
};

#endif // PARSER_H
