# this script is copied into the bee install package
# a user runs this script to install bee on its machine
# what it does:
# 1. copy everything to the ~/.opt/bee/ directory
# 2. create a ~/.bin/ directory with symlinks to the bee executables


mkdir -p "$HOME/.opt/bee/binaries"
mkdir -p "$HOME/.opt/bee/standard library"
mkdir -p "$HOME/.opt/bin"

cp bee ~/.opt/bee/binaries/
cp beerun ~/.opt/bee/binaries/

ln -sf ~/.opt/bee/binaries/bee ~/.opt/bin/bee
ln -sf ~/.opt/bee/binaries/beerun ~/.opt/bin/beerun

cp -r "standard library" ~/.opt/bee/

if ! grep -qe "/.opt/bin" ~/.profile;
then
	# temporary change of the path
	export PATH="$PATH:$HOME/.opt/bin"
	# permanent changes of the path in .profile
	echo '' >> ~/.profile
	echo '# add the bin location to the PATH' >> ~/.profile
	echo 'PATH="$PATH:$HOME/.opt/bin"' >> ~/.profile
fi

echo 'Installation completed, all data put into ~/.opt/bee/'
